package danvojtekdm;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.util.Random;
import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {

    protected Item choosenItem = null;
    protected Item previousChoosenItem = null;
    public ArrayList<Item> itemsToRunAround = new ArrayList<Item>();
    public ArrayList<Item> medkitsToRunAround = null;
    public ArrayList<Item> armorsToRunAround = null;
    protected boolean jumped = true;
    protected boolean medsRestart = true;
    protected boolean armorsRestart = true;
    
    private Player lastEnemy = null;
    private Player enemy = null;
    
    private Random random = new Random();
    private Object mutex = new Object();
    
    private Triple startingPursuePosition = null;
    private int pursuingActions = 0;
    
    private KILListener kilListener = new KILListener();
    private DIEListener dieListener = new DIEListener();
    
    private class KILListener implements RcvMsgListener {
        public KILListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            synchronized (mutex) {
                log.info("PLAYER_KILLED message received");
                PlayerKilled pk = (PlayerKilled) e.getMessage();
                if (lastEnemy != null && pk.playerID == lastEnemy.ID) {
                    lastEnemy = null;
                    enemy = null;
                    log.info("It was player which I was pursuing.");
                } 
            }
        }       
    }
    
    private class DIEListener implements RcvMsgListener {
        public DIEListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            log.info("BOT DIED message received");
            lastEnemy = null;
            enemy = null;
            medsRestart = true;
            armorsRestart = true;
        }
        
        
    }
    
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
    }

    public void action_rearm() {
        pursuingActions = 0;
        this.log.info("Action REARM.");
        AddWeapon weapon = this.bot.getMemory().getBetterWeapon(this.bot.getMemory().getSeeEnemy().location, this.bot.getMemory().getAgentLocation());
        this.bot.getBody().changeWeapon(weapon);
    }

    public void action_engageEnemy() {
        synchronized (mutex) {
        pursuingActions = 0;
        this.log.info("Action ENGAGE_ENEMY.");
        this.medsRestart = true;
        this.armorsRestart = true;

        if (this.enemy != null) {
            this.lastEnemy = enemy;
            this.enemy = this.bot.getMemory().getSeePlayer(this.enemy.ID); // refresh information about the enemy,
            // note that even though we've got pointer to the message of the enemy seen, it's still a certain message 
            // from a specific time - when new message arrives it's written as a new message
            if (this.enemy == null) {
                if (this.bot.getMemory().isShooting()) {
                    this.bot.getBody().stopShoot();
                } // stop shooting, we've lost target
                return;
            }
        }

        // 2) if doesn't have enemy - pick one of the enemy for pursuing
        if (this.enemy == null) {
            this.enemy = this.bot.getMemory().getSeeEnemy();
            if (this.enemy == null) {
                this.bot.getBody().stop();
                this.bot.getBody().stopShoot();
                return;
            }
        }

        AddWeapon weapon = null;
        // 3) if out of ammo - switch to another weapon
        if ((!this.bot.getMemory().hasLoadedWeapon()) && this.bot.getMemory().hasAnyLoadedWeapon()) {
            this.log.info("no ammo - switching weapon " + this.bot.getMemory().hasLoadedWeapon() + " " + this.bot.getMemory().getAnyWeapon() + "\nCurrent Weapon:" + this.bot.getMemory().getCurrentWeapon() + "\nWeapons : " + this.bot.getMemory().getAllWeapons().toString());
            weapon = this.bot.getMemory().getAnyWeapon();
            if ((weapon != null) && ((this.bot.getMemory().getCurrentWeapon() == null) || ((this.bot.getMemory().getCurrentWeapon() != null) && (!weapon.weaponType.equals(this.bot.getMemory().getCurrentWeapon().weaponType))))) {
                 this.log.info("no ammo - switching weapon: " + weapon);
                this.bot.getBody().changeWeapon(weapon);
            } else {
                //nema ani za co vymenit?
               this.log.info("no weapon to switch .. too bad");
            }
        }

        // 4) if not shooting at enemyID - start shooting
        double distance = (Triple.distanceInSpace(this.bot.getMemory().getAgentLocation(), this.enemy.location));
        if (this.bot.getMemory().getCurrentWeapon() != null && this.bot.getMemory().getCurrentWeapon().maxDist > distance) {// it is worth shooting
            this.log.info("Would like to shoot at enemy!!!");
            if (!this.bot.getMemory().isShooting()) {
                this.bot.getBody().shoot(this.enemy);
            } else // to turn to enemy - shoot will not turn to enemy during shooting
            {
                this.bot.getBody().turnToTarget(this.enemy);
            }
        }

        // 5) if enemy is far - run to him
        // co to je za cislo preboha?
        int decentDistance = Math.round(this.random.nextFloat() * 800) + 200;

        if (this.bot.getMemory().getAgentLocation() != null && this.enemy != null && this.enemy.location != null &&
                Triple.distanceInSpace(this.bot.getMemory().getAgentLocation(), this.enemy.location) < decentDistance) {
            if (this.bot.getMemory().isMoving()) {
                this.bot.getBody().stop();
            }
        } else {
            this.bot.getBody().runToTarget(enemy);
            this.jumped = false;
        }
        }
        //this.bot.getBody().shoot(this.bot.getMemory().getSeeEnemy());
    }

    public void action_runAroundCloseMeds() {
        pursuingActions = 0;
        this.log.info("Action RUN_AROUND_CLOSE_MEDS.");
        this.bot.getMap().runAroundItemsInTheMap(this.medkitsToRunAround, false);
    }
    
    public void action_runAroundCloseArmors() {
        pursuingActions = 0;
        this.log.info("Action RUN_AROUND_CLOSE_ARMORS.");
        this.bot.getMap().runAroundItemsInTheMap(this.armorsToRunAround, false);
    }

    public void action_runAroundItems() {
        pursuingActions = 0;
        this.log.info("Action RUN_AROUND_ITEMS " + this.itemsToRunAround.size() + ".");
        this.bot.getMap().runAroundItemsInTheMap(this.itemsToRunAround, false);
    }

    public void action_runToItem() {
        pursuingActions = 0;
        this.log.info("Action RUN_TO_ITEM.");
        if (!this.bot.getMap().safeRunToLocation(choosenItem.location)) {
            // unable to reach the choosen item
            log.info("unable to REACH the choosen item");
            previousChoosenItem = choosenItem;
            choosenItem = null;
        }
    }

    public void action_stopShooting() {
        pursuingActions = 0;
        this.log.info("Action STOP_SHOOTING.");
        this.bot.getBody().stopShoot();
    }

    public void action_jump() {
        pursuingActions = 0;
        this.log.info("Action JUMP.");
        if (this.bot.getMemory().isColliding()) {
            if (!this.jumped) {
                this.bot.getBody().jump();
                this.jumped = true;
            } else {
                this.bot.getBody().stop();
                this.jumped = false;
            }
        }
        if (this.bot.getMemory().isFalling()) {
            this.bot.getBody().sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.bot.getMemory().isBumpingToAnotherActor()) {
            this.bot.getBody().stop();
        }
    }

    public boolean action_doNothing() {
        pursuingActions = 0;
        return true;
    }

    public void action_turnAround() {
        pursuingActions = 0;
        this.log.info("Action TURN_AROUND.");
        this.bot.getBody().turnHorizontal(55);
    }
    
    public void action_pursueEnemy() {
        synchronized (mutex) {
        pursuingActions++;
        this.log.info("Decision is: PURSUE" + lastEnemy.UnrealID + " " + lastEnemy.ID);
        if (!this.bot.getMap().safeRunToLocation(lastEnemy.location)) {         // unable to reach the choosen item
            log.info("Ended at the enemy possition or failed - > STOP THE CHASE.");
            previousChoosenItem = choosenItem;
            lastEnemy = null;
        }
        // on each first store my actual position
        if (this.startingPursuePosition == null || (this.pursuingActions  % 10 == 1)) {
            this.startingPursuePosition = this.bot.getMemory().getAgentLocation();
        }
        if (this.pursuingActions % 10 == 0) {
            if (Triple.distanceInSpace(this.startingPursuePosition, this.bot.getMemory().getAgentLocation()) < 100) {
                // leave pursue
                log.info("After 10 pursuing attempts I have not moved so quitting pursue ...");
                lastEnemy = null;
                enemy = null;
            }
            // reset pursuing actions .. not necessary cause % would work either
            this.pursuingActions = 0;
        }
        }
        return;
    }

    @Override
    public boolean sense_fail() {
        return false;
    }

    @Override
    public boolean sense_succeed() {
        return true;
    }

    public boolean sense_stucked() {
        return bot.getMemory().isColliding();
    }

    public boolean sense_isShooting() {
        return bot.getMemory().isShooting();
    }

    public boolean sense_hasBetterWeapon() {
        Triple botLoc = bot.getMemory().getAgentLocation();
        Player seenEnemy = bot.getMemory().getSeeEnemy();
        if (seenEnemy == null || seenEnemy.location == null) {
            return false;
        }
        AddWeapon candidate = bot.getMemory().getBetterWeapon(botLoc, seenEnemy.location);
        if (candidate != null) {
            return true;
        } else {
            return false;
        }
    }

    public int sense_health() {
        return bot.getMemory().getAgentHealth();
    }

    public boolean sense_knowMedkits() {
        if (medsRestart) {
            this.medkitsToRunAround = null;
        }
        if (this.medkitsToRunAround != null) {
            return true;
        }
        ArrayList<Item> healths = this.bot.getMap().nearestHealth(15, 4);
        if (healths == null || healths.size() < 2) {
            return false;
        }
        this.medkitsToRunAround = healths;
        return true;
    }
    
    public int sense_armor() {
        return this.bot.getMemory().getAgentArmor();
    }
    
    public boolean sense_knowArmors() {
        if (armorsRestart) {
            this.armorsToRunAround = null;
        }
        if (this.armorsToRunAround != null) {
            return true;
        }
        ArrayList<Item> armors = this.bot.getMap().nearestItems(MessageType.ARMOR, 2);
        if (armors == null || armors.size() < 2) {
            return false;
        }
        this.armorsToRunAround = armors;
        return true;
    }

    public boolean sense_armed() {
        return bot.getMemory().hasAnyLoadedWeapon();
    }

    public boolean sense_seeEnemy() {
        return bot.getMemory().getSeeAnyEnemy();
    }

    public boolean sense_seeItemAndWantIt() {
        return this.seeAnyReachableItemAndWantIt();
    }

    public boolean sense_isShotAt() {
        return bot.getMemory().isBeingDamaged() || bot.getMemory().isProjectileComming();
    }
    
    public boolean sense_haveSeenEnemy() {
        return this.lastEnemy != null;
    }

    //#############################################################
    // auxiliary functions
    //#############################################################
    /** 
     * choose weapon according to the one he is currently holding
     * <ol>
     * <li> has melee and see ranged => pick up ranged
     * <li> has ranged and see melee => pick up melee
     * <li> pick up first weapon he sees
     * </ol>
     * 
     * @return the choosen one weapon
     */
    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = bot.getMemory().getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            // 0) has no weapon in hands
            if (this.bot.getMemory().getCurrentWeapon() == null) {
                return weapon;
            }
            // 1) weapon is ranged, bot has melee
            if ((this.bot.getMemory().getCurrentWeapon().melee) && !weapon.isMelee() && !this.bot.getMemory().hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            // 2) weapon is melee, bot has ranged
            if (!this.bot.getMemory().getCurrentWeapon().melee && weapon.isMelee() && !this.bot.getMemory().hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
        }
        Weapon chosen = this.bot.getMemory().getSeeReachableWeapon();
        if (!this.bot.getMemory().hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    /**
     * Reasoning about what to do with seen item <br>
     * the easiest way of handeling it will be just to take it every time, but what should we do
     * when there are many of items laying in front of agent?
     * <ol>
     * <li> choose weapon - choose the type he is lacking (melee/ranged)
     * <li> choose armor
     * <li> choose health - if the health is bellow normal maximum
     * <li> choose ammo - if it is suitable for possessed weapons
     * <li> ignore the item
     * </ol>
     */
    private Item chooseItem() {
        // 1) choose weapon - choose the type he is lacking (melee/ranged)
        if (this.bot.getMemory().getSeeAnyReachableWeapon()) {
            return chooseWeapon();
        }
        // 2) choose armor
        if (this.bot.getMemory().getSeeAnyReachableArmor()) {
            return this.bot.getMemory().getSeeReachableArmor();
        }
        // 3) choose health - if the health is bellow normal maximum or the item is boostable
        if (this.bot.getMemory().getSeeAnyReachableHealth()) {
            Health health = this.bot.getMemory().getSeeReachableHealth();
            if (this.bot.getMemory().getAgentHealth() < 100) {
                return health;
            }
            if (health.boostable) // if the health item is boostable, grab it anyway:)
            {
                return health;
            }
        }
        // 4) choose ammo - if it is suitable for possessed weapons
        if ((this.bot.getMemory().getSeeAnyReachableAmmo()) &&
                (this.bot.getMemory().isAmmoSuitable(this.bot.getMemory().getSeeReachableAmmo()))) {
            return this.bot.getMemory().getSeeReachableAmmo();
        }
        // 5) ignore the item
        return null;
    }

    /** 
     * sees reachable item and wants it
     * @return true if there is an item which is useful for agent
     */
    private boolean seeAnyReachableItemAndWantIt() {
        if (this.bot.getMemory().getSeeAnyReachableItem()) {
            choosenItem = chooseItem();
            if (choosenItem != null) {
                this.log.info("NEW ITEM CHOSEN: " + choosenItem);
                this.log.info("LAST CHOOSEN ITEM: " + previousChoosenItem);
            }
        } else {
            choosenItem = null;
        }
        if ((choosenItem != null) && (!choosenItem.equals(previousChoosenItem))) //&& (Triple.distanceInSpace(memory.getAgentLocation(), choosenItem.location) > 20))
        {
            return true;
        } else {
            return false;
        }
    }
}
